<?php
	class st_hybrid_blogpost_sidebar extends WP_Widget{
	
		function st_hybrid_blogpost_sidebar() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > BlogPost Sidebar');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title1 = apply_filters('widget_title', $instance['title']);		
			global $post;
			setup_postdata( $post );
			echo $before_widget;	
			  ?>
			
					<h3><?php echo $title1;?></h3>
	    			<div class="accordion" id="accordion100" style="clear:both;">
					    <?php
                            $args1 = array(
                                'post_type' => 'post',  
								'meta_key' => 'hybrid_view',
								'orderby' => 'meta_value_num',	
								'order' => 'DESC' ,
								'posts_per_page' => 3
                            );
                            $the_query = new WP_Query($args1);
							$counter = 0;
                            while ( $the_query->have_posts() ):
                                $the_query->the_post();
								
                        ?>
					    <div class="accordion-group">
					    <div class="accordion-heading">
							<a class="accordion-toggle" href="<?php the_permalink();?>">
								<div class="border-container">
									<div class="comment-size-box">
									<p class="comment-number">
										<?php echo get_comments_number();?>
									</p></div>
									<div class="triangle-box">
										<div class="triangle triangle-border"></div>
										<div class="triangle triangle-body"></div>
									</div>
								</div>								
								<p class="post-title-bigger"><?php the_title();?></p>
								<p class="post-categoty-bigger">
								<?php 
										$post_categories = wp_get_post_categories( $post->ID );								
										$categories = '';	
										foreach($post_categories as $c){
											$cat = get_category( $c );									
											$categories = $categories.' '.$cat->name;
										}
										echo 'Posted in '.$categories;
										?></p>
							</a>
					    </div>
						</div>
						<?php 
						$counter++;						
						endwhile;
						wp_reset_postdata();
						?>
					</div>
					<?php
          echo $after_widget;
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<?php
		}
	}
	
	function st_hybrid_widgets_blogposts_sidebar() {			
		register_widget('st_hybrid_blogpost_sidebar');			
	}
	add_action('widgets_init', 'st_hybrid_widgets_blogposts_sidebar');
?>